
CREATE OR REPLACE FUNCTION addColumn()
RETURNS VOID AS
$BODY$
BEGIN
    IF EXISTS (SELECT 1 FROM information_schema.columns     
                    WHERE table_name= 'rc_adm_cartao_parc_minima') THEN
                         
        RAISE NOTICE 'Tabela "rc_adm_cartao_parc_minima" JA EXISTE!' ;
    ELSE
        CREATE TABLE public.rc_adm_cartao_parc_minima
		(
		  cd_emp integer NOT NULL,
		  parc integer NOT NULL,
		  vlr_min_parc money NOT NULL,
		  qtd_max_parc integer NOT NULL,
		  sts_parc integer NOT NULL,
		  dt_cad date NOT NULL,
		  cd_usu integer,
		  CONSTRAINT pk_rc_adm_cartao_parc_minima PRIMARY KEY (cd_emp, parc)
		)
		WITH (
		  OIDS=FALSE
		);
		ALTER TABLE public.rc_adm_cartao_parc_minima
		  OWNER TO postgres;    
        RAISE NOTICE 'Tabela "rc_adm_cartao_parc_minima" CRIADA COM SUCESSO!';
    END IF; 
    
END;
-- fim bloco principal
$BODY$
LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION addColumn()  OWNER TO postgres;
SELECT addColumn();
DROP FUNCTION addColumn();